/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.remsrv;

import com.ibm.hwmca.base.remsrv.RemoteServiceBean;
import com.ibm.hwmca.base.remsrv.RemoteServiceData;
import com.ibm.hwmca.base.remsrv.RemoteServiceErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class RemoteServiceTasklet
extends PanelTasklet
implements RemoteServiceErrorIds {
    private static final String TRACE_MASKT = "HREMTLTT";
    private static final String TRACE_MASKF = "HREMTLTF";
    private static final String TRACE_MASKD = "HREMTLTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-110, "RemServTsklt");
    private static final String AUIML = "com.ibm.hwmca.base.remsrv.res.RemoteServiceRes";
    private static final String PANEL = "RemoteServiceConfigurationPanel";
    private static final String PARENT_BEAN = "BASETOWERSETTINGSBEAN";
    private RemoteServiceBean bean;
    private RemoteServiceData data;

    public RemoteServiceTasklet() {
        Trace.trace(TRACE_MASKT, "<> RemoteServiceTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        try {
            this.bean = new RemoteServiceBean();
            this.bean.setBeanName("RemoteServiceBean");
            this.data = RemoteServiceData.getRemoteServiceData();
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            this.bean.setEnableRemoteServiceToggle(rsf != null && rsf.isCallHomeEnabled());
            this.bean.setAuthorAutoSCRToggle(this.data.isAutoServiceCall());
            this.bean.setCSCPhoneNumEdit(this.data.getServiceNumber());
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 2, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                response.replace(AUIML, PANEL, this.bean);
            } else if (request.isDisposed() || request.isCanceled()) {
                PanelTaskletRequest newRequest = new PanelTaskletRequest();
                newRequest.setDisposed();
                if (this.isSubtasklet()) {
                    this.getParent().postRequest(PARENT_BEAN, newRequest);
                }
                response.terminate();
            } else {
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "action = " + action);
                if (action.equals("commit")) {
                    this.bean = (RemoteServiceBean)request.getData("bean");
                    RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
                    if (rsf != null) {
                        rsf.setCallHomeEnabled(this.bean.isEnableRemoteServiceToggle());
                    }
                    this.data.setAutoServiceCall(this.bean.isAuthorAutoSCRToggle());
                    this.data.setServiceNumber(this.bean.getCSCPhoneNumEdit());
                    PanelTaskletRequest newRequest = new PanelTaskletRequest();
                    newRequest.setDisposed();
                    if (this.isSubtasklet()) {
                        this.getParent().postRequest(PARENT_BEAN, newRequest);
                    }
                    response.terminate();
                } else {
                    response.noAction();
                }
            }
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 3, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 1, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }
}

